/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.platform.NativeImage;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeList;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.plugins.CategoryManager;
import de.maxhenkel.voicechat.plugins.impl.VolumeCategoryImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class ClientCategoryManager
extends CategoryManager {
    protected final Map<String, ResourceLocation> images = new ConcurrentHashMap<String, ResourceLocation>();

    public ClientCategoryManager() {
        CommonCompatibilityManager.INSTANCE.getNetManager().addCategoryChannel.setClientListener((client, handler, packet) -> {
            this.addCategory(packet.getCategory());
            Voicechat.logDebug("Added category {}", packet.getCategory().getId());
        });
        CommonCompatibilityManager.INSTANCE.getNetManager().removeCategoryChannel.setClientListener((client, handler, packet) -> {
            this.removeCategory(packet.getCategoryId());
            Voicechat.logDebug("Removed category {}", packet.getCategoryId());
        });
        ClientCompatibilityManager.INSTANCE.onDisconnect(this::clear);
    }

    @Override
    public void addCategory(VolumeCategoryImpl category) {
        super.addCategory(category);
        if (category.getIcon() != null) {
            this.registerImage(category.getId(), this.fromIntArray(category.getIcon()));
        }
        AdjustVolumeList.update();
    }

    @Override
    @Nullable
    public VolumeCategoryImpl removeCategory(String categoryId) {
        VolumeCategoryImpl volumeCategory = super.removeCategory(categoryId);
        this.unRegisterImage(categoryId);
        AdjustVolumeList.update();
        return volumeCategory;
    }

    public void clear() {
        this.categories.keySet().forEach(this::unRegisterImage);
        this.categories.clear();
    }

    private void registerImage(String id, NativeImage image) {
        ResourceLocation resourceLocation = Minecraft.m_91087_().m_91290_().f_114357_.m_118490_(id, new DynamicTexture(image));
        this.images.put(id, resourceLocation);
    }

    private void unRegisterImage(String id) {
        ResourceLocation resourceLocation = this.images.get(id);
        if (resourceLocation != null) {
            Minecraft.m_91087_().m_91290_().f_114357_.m_118513_(resourceLocation);
            this.images.remove(id);
        }
    }

    private NativeImage fromIntArray(int[][] icon) {
        if (icon.length != 16) {
            throw new IllegalStateException("Icon is not 16x16");
        }
        NativeImage nativeImage = new NativeImage(16, 16, true);
        for (int x = 0; x < icon.length; ++x) {
            if (icon[x].length != 16) {
                nativeImage.close();
                throw new IllegalStateException("Icon is not 16x16");
            }
            for (int y = 0; y < icon.length; ++y) {
                nativeImage.m_84988_(x, y, icon[x][y]);
            }
        }
        return nativeImage;
    }

    public ResourceLocation getTexture(String id, ResourceLocation defaultImage) {
        return this.images.getOrDefault(id, defaultImage);
    }
}

