/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.resourcepacks;

import com.google.common.collect.ImmutableSet;
import de.maxhenkel.voicechat.Voicechat;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class VoiceChatResourcePack
extends AbstractPackResources {
    public VoiceChatResourcePack(String id) {
        super(id, true);
    }

    public Pack toPack(Component name) {
        Pack.ResourcesSupplier resourcesSupplier = s -> this;
        Pack.Info info = Pack.m_246334_((String)"", (Pack.ResourcesSupplier)resourcesSupplier);
        if (info == null) {
            info = new Pack.Info(name, SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES), FeatureFlagSet.m_247091_((FeatureFlag)FeatureFlags.f_244571_));
        }
        return Pack.m_245512_((String)this.m_5542_(), (Component)name, (boolean)false, (Pack.ResourcesSupplier)resourcesSupplier, (Pack.Info)info, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_);
    }

    private String getPath() {
        return "/packs/" + this.m_5542_() + "/";
    }

    @Nullable
    private InputStream get(String name) {
        return Voicechat.class.getResourceAsStream(this.getPath() + name);
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... strings) {
        return this.getResource(String.join((CharSequence)"/", strings));
    }

    private static String getPathFromLocation(PackType packType, ResourceLocation resourceLocation) {
        return String.format(Locale.ROOT, "%s/%s/%s", packType.m_10305_(), resourceLocation.m_135827_(), resourceLocation.m_135815_());
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation resourceLocation) {
        return this.getResource(VoiceChatResourcePack.getPathFromLocation(packType, resourceLocation));
    }

    @Nullable
    private IoSupplier<InputStream> getResource(String path) {
        InputStream resourceAsStream = this.get(path);
        if (resourceAsStream == null) {
            return null;
        }
        return () -> resourceAsStream;
    }

    public void m_8031_(PackType type, String namespace, String prefix, PackResources.ResourceOutput resourceOutput) {
        try {
            URL url = Voicechat.class.getResource(this.getPath());
            if (url == null) {
                return;
            }
            Path resPath = Paths.get(url.toURI());
            String absolutePath = type.m_10305_() + "/" + namespace + "/";
            String absolutePrefixPath = absolutePath + prefix + "/";
            try (Stream<Path> files = Files.walk(resPath, new FileVisitOption[0]);){
                files.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    String name = path.getFileName().toString();
                    if (!name.endsWith(".mcmeta") && name.startsWith(absolutePrefixPath)) {
                        ResourceLocation resourceLocation = new ResourceLocation(namespace, name.substring(absolutePath.length()));
                        resourceOutput.accept((Object)resourceLocation, this.m_214146_(type, resourceLocation));
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Set<String> m_5698_(PackType packType) {
        if (packType == PackType.CLIENT_RESOURCES) {
            return ImmutableSet.of((Object)"voicechat");
        }
        return ImmutableSet.of();
    }

    public void close() {
    }
}

