/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.permission.Permission;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerPlayer;

public class VoicechatCommands {
    public static final String VOICECHAT_COMMAND = "voicechat";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literalBuilder = Commands.m_82127_((String)VOICECHAT_COMMAND);
        literalBuilder.executes(commandSource -> VoicechatCommands.help(dispatcher, (CommandContext<CommandSourceStack>)commandSource));
        literalBuilder.then(Commands.m_82127_((String)"help").executes(commandSource -> VoicechatCommands.help(dispatcher, (CommandContext<CommandSourceStack>)commandSource)));
        literalBuilder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"test").requires(commandSource -> VoicechatCommands.checkPermission(commandSource, PermissionManager.INSTANCE.ADMIN_PERMISSION))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSourceStack>)commandSource)) {
                return 0;
            }
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)commandSource, (String)"target");
            Server server = Voicechat.SERVER.getServer();
            if (server == null) {
                ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237115_((String)"message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            if (!Voicechat.SERVER.isCompatible(player)) {
                ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237110_((String)"message.voicechat.player_no_voicechat", (Object[])new Object[]{player.m_5446_(), CommonCompatibilityManager.INSTANCE.getModName()}), false);
                return 1;
            }
            ClientConnection clientConnection = server.getConnections().get(player.m_20148_());
            if (clientConnection == null) {
                ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237115_((String)"message.voicechat.client_not_connected"), false);
                return 1;
            }
            try {
                ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237115_((String)"message.voicechat.sending_ping"), false);
                server.getPingManager().sendPing(clientConnection, 500L, 10, new PingManager.PingListener(){

                    @Override
                    public void onPong(int attempts, long pingMilliseconds) {
                        if (attempts <= 1) {
                            ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237110_((String)"message.voicechat.ping_received", (Object[])new Object[]{pingMilliseconds}), false);
                        } else {
                            ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237110_((String)"message.voicechat.ping_received_attempt", (Object[])new Object[]{attempts, pingMilliseconds}), false);
                        }
                    }

                    @Override
                    public void onFailedAttempt(int attempts) {
                        ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237115_((String)"message.voicechat.ping_retry"), false);
                    }

                    @Override
                    public void onTimeout(int attempts) {
                        ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237110_((String)"message.voicechat.ping_timed_out", (Object[])new Object[]{attempts}), false);
                    }
                });
                ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237115_((String)"message.voicechat.ping_sent_waiting"), false);
            }
            catch (Exception e) {
                ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237110_((String)"message.voicechat.failed_to_send_ping", (Object[])new Object[]{e.getMessage()}), false);
                e.printStackTrace();
                return 1;
            }
            return 1;
        })));
        literalBuilder.then(Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSourceStack>)commandSource)) {
                return 0;
            }
            ServerPlayer source = ((CommandSourceStack)commandSource.getSource()).m_81375_();
            Server server = Voicechat.SERVER.getServer();
            if (server == null) {
                ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237115_((String)"message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            PlayerState state = server.getPlayerStateManager().getState(source.m_20148_());
            if (state == null || !state.hasGroup()) {
                ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237115_((String)"message.voicechat.not_in_group"), false);
                return 1;
            }
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)commandSource, (String)"target");
            Group group = server.getGroupManager().getGroup(state.getGroup());
            if (group == null) {
                return 1;
            }
            if (!Voicechat.SERVER.isCompatible(player)) {
                ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237110_((String)"message.voicechat.player_no_voicechat", (Object[])new Object[]{player.m_5446_(), CommonCompatibilityManager.INSTANCE.getModName()}), false);
                return 1;
            }
            String passwordSuffix = group.getPassword() == null ? "" : " \"" + group.getPassword() + "\"";
            player.m_213846_((Component)Component.m_237110_((String)"message.voicechat.invite", (Object[])new Object[]{source.m_5446_(), Component.m_237113_((String)group.getName()).m_130940_(ChatFormatting.GRAY), ComponentUtils.m_130748_((Component)Component.m_237115_((String)"message.voicechat.accept_invite").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/voicechat join " + group.getId().toString() + passwordSuffix)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"message.voicechat.accept_invite.hover"))))).m_130940_(ChatFormatting.GREEN)}));
            ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237110_((String)"message.voicechat.invite_successful", (Object[])new Object[]{player.m_5446_()}), false);
            return 1;
        })));
        literalBuilder.then(Commands.m_82127_((String)"join").then(Commands.m_82129_((String)"group", (ArgumentType)UuidArgument.m_113850_()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSourceStack>)commandSource)) {
                return 0;
            }
            UUID groupID = UuidArgument.m_113853_((CommandContext)commandSource, (String)"group");
            return VoicechatCommands.joinGroup((CommandSourceStack)commandSource.getSource(), groupID, null);
        })));
        literalBuilder.then(Commands.m_82127_((String)"join").then(Commands.m_82129_((String)"group", (ArgumentType)UuidArgument.m_113850_()).then(Commands.m_82129_((String)"password", (ArgumentType)StringArgumentType.string()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSourceStack>)commandSource)) {
                return 0;
            }
            UUID groupID = UuidArgument.m_113853_((CommandContext)commandSource, (String)"group");
            String password = StringArgumentType.getString((CommandContext)commandSource, (String)"password");
            return VoicechatCommands.joinGroup((CommandSourceStack)commandSource.getSource(), groupID, password.isEmpty() ? null : password);
        }))));
        literalBuilder.then(Commands.m_82127_((String)"leave").executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSourceStack>)commandSource)) {
                return 0;
            }
            if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
                ((CommandSourceStack)commandSource.getSource()).m_81352_((Component)Component.m_237115_((String)"message.voicechat.groups_disabled"));
                return 1;
            }
            Server server = Voicechat.SERVER.getServer();
            if (server == null) {
                ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237115_((String)"message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            ServerPlayer source = ((CommandSourceStack)commandSource.getSource()).m_81375_();
            PlayerState state = server.getPlayerStateManager().getState(source.m_20148_());
            if (state == null || !state.hasGroup()) {
                ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237115_((String)"message.voicechat.not_in_group"), false);
                return 1;
            }
            server.getGroupManager().leaveGroup(source);
            ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237115_((String)"message.voicechat.leave_successful"), false);
            return 1;
        }));
        dispatcher.register(literalBuilder);
    }

    private static int joinGroup(CommandSourceStack source, UUID groupID, @Nullable String password) throws CommandSyntaxException {
        if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
            source.m_81352_((Component)Component.m_237115_((String)"message.voicechat.groups_disabled"));
            return 1;
        }
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            source.m_288197_(() -> Component.m_237115_((String)"message.voicechat.voice_chat_unavailable"), false);
            return 1;
        }
        ServerPlayer player = source.m_81375_();
        if (!PermissionManager.INSTANCE.GROUPS_PERMISSION.hasPermission(player)) {
            source.m_288197_(() -> Component.m_237115_((String)"message.voicechat.no_group_permission"), false);
            return 1;
        }
        Group group = server.getGroupManager().getGroup(groupID);
        if (group == null) {
            source.m_81352_((Component)Component.m_237115_((String)"message.voicechat.group_does_not_exist"));
            return 1;
        }
        server.getGroupManager().joinGroup(group, player, password);
        source.m_288197_(() -> Component.m_237110_((String)"message.voicechat.join_successful", (Object[])new Object[]{Component.m_237113_((String)group.getName()).m_130940_(ChatFormatting.GRAY)}), false);
        return 1;
    }

    private static int help(CommandDispatcher<CommandSourceStack> dispatcher, CommandContext<CommandSourceStack> commandSource) {
        if (VoicechatCommands.checkNoVoicechat(commandSource)) {
            return 0;
        }
        CommandNode voicechatCommand = dispatcher.getRoot().getChild(VOICECHAT_COMMAND);
        Map map = dispatcher.getSmartUsage(voicechatCommand, (Object)((CommandSourceStack)commandSource.getSource()));
        for (Map.Entry entry : map.entrySet()) {
            ((CommandSourceStack)commandSource.getSource()).m_288197_(() -> Component.m_237113_((String)"/%s %s".formatted(VOICECHAT_COMMAND, entry.getValue())), false);
        }
        return map.size();
    }

    private static boolean checkNoVoicechat(CommandContext<CommandSourceStack> commandSource) {
        try {
            ServerPlayer player = ((CommandSourceStack)commandSource.getSource()).m_81375_();
            if (Voicechat.SERVER.isCompatible(player)) {
                return false;
            }
            ((CommandSourceStack)commandSource.getSource()).m_81352_((Component)Component.m_237113_((String)Voicechat.TRANSLATIONS.voicechatNeededForCommandMessage.get().formatted(CommonCompatibilityManager.INSTANCE.getModName())));
            return true;
        }
        catch (Exception e) {
            ((CommandSourceStack)commandSource.getSource()).m_81352_((Component)Component.m_237113_((String)Voicechat.TRANSLATIONS.playerCommandMessage.get()));
            return true;
        }
    }

    private static boolean checkPermission(CommandSourceStack stack, Permission permission) {
        try {
            return permission.hasPermission(stack.m_81375_());
        }
        catch (CommandSyntaxException e) {
            return stack.m_6761_(stack.m_81377_().m_7022_());
        }
    }
}

