/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.platform;

import architectury_inject_architectury_common_5d605134964d42b1aa8d9fabeb63fc8a_b1f04e416b5bbe8f458db543b464cfd1939a87b1a08aae9cc9911fa70f1dc75carchitectury908devjar.PlatformMethods;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Mod;
import dev.architectury.platform.forge.PlatformImpl;
import dev.architectury.utils.Env;
import java.nio.file.Path;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraftforge.api.distmarker.Dist;

public final class Platform {
    private static int simpleLoaderCache = -1;

    private Platform() {
    }

    public static boolean isFabric() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 0;
    }

    public static boolean isForge() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 1;
    }

    private static void updateLoaderCache() {
        if (simpleLoaderCache != -1) {
            return;
        }
        switch (PlatformMethods.getCurrentTarget()) {
            case "fabric": {
                simpleLoaderCache = 0;
                break;
            }
            case "forge": {
                simpleLoaderCache = 1;
            }
        }
    }

    public static String getMinecraftVersion() {
        return SharedConstants.m_183709_().m_132492_();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGameFolder() {
        return PlatformImpl.getGameFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigFolder() {
        return PlatformImpl.getConfigFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getModsFolder() {
        return PlatformImpl.getModsFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Env getEnvironment() {
        return PlatformImpl.getEnvironment();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Dist getEnv() {
        return PlatformImpl.getEnv();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String id) {
        return PlatformImpl.isModLoaded(id);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Mod getMod(String id) {
        return PlatformImpl.getMod(id);
    }

    public static Optional<Mod> getOptionalMod(String id) {
        try {
            return Optional.of(Platform.getMod(id));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<Mod> getMods() {
        return PlatformImpl.getMods();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<String> getModIds() {
        return PlatformImpl.getModIds();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDevelopmentEnvironment() {
        return PlatformImpl.isDevelopmentEnvironment();
    }
}

