/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.function.BiFunction;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.xolt.freecam.config.ConfigScreen;
import net.xolt.freecam.config.FreecamConfig;
import net.xolt.freecam.util.FreeCamera;
import net.xolt.freecam.util.FreecamPosition;

@Mod(value="freecam")
public class Freecam {
    public static final String MOD_ID = "freecam";
    public static final Minecraft MC = Minecraft.m_91087_();
    public static final KeyMapping KEY_TOGGLE = new KeyMapping("key.freecam.toggle", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 293, "category.freecam.freecam");
    public static final KeyMapping KEY_PLAYER_CONTROL = new KeyMapping("key.freecam.playerControl", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "category.freecam.freecam");
    public static final KeyMapping KEY_TRIPOD_RESET = new KeyMapping("key.freecam.tripodReset", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "category.freecam.freecam");
    public static final KeyMapping KEY_CONFIG_GUI = new KeyMapping("key.freecam.configGui", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "category.freecam.freecam");
    private static boolean freecamEnabled = false;
    private static boolean tripodEnabled = false;
    private static boolean playerControlEnabled = false;
    private static boolean disableNextTick = false;
    private static Integer activeTripod = null;
    private static FreeCamera freeCamera;
    private static HashMap<Integer, FreecamPosition> overworld_tripods;
    private static HashMap<Integer, FreecamPosition> nether_tripods;
    private static HashMap<Integer, FreecamPosition> end_tripods;
    private static CameraType rememberedF5;

    public Freecam() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)FreecamConfig.SPEC, "freecam.toml");
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((BiFunction)new BiFunction<Minecraft, Screen, Screen>(){

            @Override
            public Screen apply(Minecraft minecraft, Screen screen) {
                return new ConfigScreen(screen);
            }
        }));
    }

    public static void toggle() {
        if (tripodEnabled) {
            Freecam.toggleTripod(activeTripod);
            return;
        }
        if (freecamEnabled) {
            Freecam.onDisableFreecam();
        } else {
            Freecam.onEnableFreecam();
        }
        boolean bl = freecamEnabled = !freecamEnabled;
        if (!freecamEnabled) {
            Freecam.onDisabled();
        }
    }

    public static void toggleTripod(Integer keyCode) {
        if (keyCode == null) {
            return;
        }
        if (tripodEnabled) {
            if (activeTripod.equals(keyCode)) {
                Freecam.onDisableTripod();
                tripodEnabled = false;
            } else {
                Freecam.onDisableTripod();
                Freecam.onEnableTripod(keyCode);
            }
        } else {
            if (freecamEnabled) {
                Freecam.toggle();
            }
            Freecam.onEnableTripod(keyCode);
            tripodEnabled = true;
        }
        if (!tripodEnabled) {
            Freecam.onDisabled();
        }
    }

    public static void switchControls() {
        if (!Freecam.isEnabled()) {
            return;
        }
        if (playerControlEnabled) {
            Freecam.freeCamera.f_108618_ = new KeyboardInput(Freecam.MC.f_91066_);
        } else {
            Freecam.MC.f_91074_.f_108618_ = new KeyboardInput(Freecam.MC.f_91066_);
            Freecam.freeCamera.f_108618_ = new Input();
        }
        playerControlEnabled = !playerControlEnabled;
    }

    private static void onEnableTripod(int keyCode) {
        Freecam.onEnable();
        FreecamPosition position = Freecam.getTripodsForDimension().get(keyCode);
        boolean chunkLoaded = false;
        if (position != null) {
            ChunkPos chunkPos = position.getChunkPos();
            chunkLoaded = Freecam.MC.f_91073_.m_7726_().m_5563_(chunkPos.f_45578_, chunkPos.f_45579_);
        }
        if (!chunkLoaded) {
            Freecam.resetCamera(keyCode);
            position = null;
        }
        freeCamera = position == null ? new FreeCamera(-420 - keyCode % 48) : new FreeCamera(-420 - keyCode % 48, position);
        freeCamera.spawn();
        MC.m_91118_((Entity)freeCamera);
        activeTripod = keyCode;
        if (((Boolean)FreecamConfig.NOTIFY_TRIPOD.get()).booleanValue()) {
            Freecam.MC.f_91074_.m_5661_((Component)Component.m_237115_((String)"msg.freecam.openTripod").m_130946_("" + activeTripod % 48), true);
        }
    }

    private static void onDisableTripod() {
        Freecam.getTripodsForDimension().put(activeTripod, new FreecamPosition((Entity)freeCamera));
        Freecam.onDisable();
        if (Freecam.MC.f_91074_ != null && ((Boolean)FreecamConfig.NOTIFY_TRIPOD.get()).booleanValue()) {
            Freecam.MC.f_91074_.m_5661_((Component)Component.m_237115_((String)"msg.freecam.closeTripod").m_130946_("" + activeTripod % 48), true);
        }
        activeTripod = null;
    }

    private static void onEnableFreecam() {
        Freecam.onEnable();
        freeCamera = new FreeCamera(-420);
        freeCamera.applyPerspective((FreecamConfig.Perspective)((Object)FreecamConfig.PERSPECTIVE.get()), (Boolean)FreecamConfig.ALWAYS_CHECK_COLLISION.get() != false || (Boolean)FreecamConfig.IGNORE_ALL_COLLISION.get() == false);
        freeCamera.spawn();
        MC.m_91118_((Entity)freeCamera);
        if (((Boolean)FreecamConfig.NOTIFY_FREECAM.get()).booleanValue()) {
            Freecam.MC.f_91074_.m_5661_((Component)Component.m_237115_((String)"msg.freecam.enable"), true);
        }
    }

    private static void onDisableFreecam() {
        Freecam.onDisable();
        if (Freecam.MC.f_91074_ != null && ((Boolean)FreecamConfig.NOTIFY_FREECAM.get()).booleanValue()) {
            Freecam.MC.f_91074_.m_5661_((Component)Component.m_237115_((String)"msg.freecam.disable"), true);
        }
    }

    private static void onEnable() {
        Freecam.MC.f_90980_ = false;
        Freecam.MC.f_91063_.m_172736_(((Boolean)FreecamConfig.SHOW_HAND.get()).booleanValue());
        rememberedF5 = Freecam.MC.f_91066_.m_92176_();
        if (Freecam.MC.f_91063_.m_109153_().m_90594_()) {
            Freecam.MC.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        }
    }

    private static void onDisable() {
        Freecam.MC.f_90980_ = true;
        Freecam.MC.f_91063_.m_172736_(true);
        MC.m_91118_((Entity)Freecam.MC.f_91074_);
        playerControlEnabled = false;
        freeCamera.despawn();
        Freecam.freeCamera.f_108618_ = new Input();
        freeCamera = null;
        if (Freecam.MC.f_91074_ != null) {
            Freecam.MC.f_91074_.f_108618_ = new KeyboardInput(Freecam.MC.f_91066_);
        }
    }

    private static void onDisabled() {
        if (rememberedF5 != null) {
            Freecam.MC.f_91066_.m_92157_(rememberedF5);
        }
    }

    public static void resetCamera(int keyCode) {
        if (tripodEnabled && activeTripod != null && activeTripod == keyCode && freeCamera != null) {
            freeCamera.m_20359_((Entity)Freecam.MC.f_91074_);
        } else {
            Freecam.getTripodsForDimension().put(keyCode, null);
        }
        if (((Boolean)FreecamConfig.NOTIFY_TRIPOD.get()).booleanValue()) {
            Freecam.MC.f_91074_.m_5661_((Component)Component.m_237115_((String)"msg.freecam.tripodReset").m_130946_("" + keyCode % 48), true);
        }
    }

    public static void clearTripods() {
        overworld_tripods = new HashMap();
        nether_tripods = new HashMap();
        end_tripods = new HashMap();
    }

    public static FreeCamera getFreeCamera() {
        return freeCamera;
    }

    public static HashMap<Integer, FreecamPosition> getTripodsForDimension() {
        return switch (Freecam.MC.f_91073_.m_220362_().m_135782_().m_135815_()) {
            case "the_nether" -> nether_tripods;
            case "the_end" -> end_tripods;
            default -> overworld_tripods;
        };
    }

    public static boolean disableNextTick() {
        return disableNextTick;
    }

    public static void setDisableNextTick(boolean damage) {
        disableNextTick = damage;
    }

    public static boolean isEnabled() {
        return freecamEnabled || tripodEnabled;
    }

    public static boolean isPlayerControlEnabled() {
        return playerControlEnabled;
    }

    static {
        overworld_tripods = new HashMap();
        nether_tripods = new HashMap();
        end_tripods = new HashMap();
        rememberedF5 = null;
    }
}

