/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.math.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class TooltipListEntry<T>
extends AbstractConfigListEntry<T> {
    @Nullable
    private Supplier<Optional<Component[]>> tooltipSupplier;

    @Deprecated
    @ApiStatus.Internal
    public TooltipListEntry(Component fieldName, @Nullable Supplier<Optional<Component[]>> tooltipSupplier) {
        this(fieldName, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public TooltipListEntry(Component fieldName, @Nullable Supplier<Optional<Component[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, requiresRestart);
        this.tooltipSupplier = tooltipSupplier;
    }

    @Override
    public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        Optional<Component[]> tooltip;
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        if (this.isMouseInside(mouseX, mouseY, x, y, entryWidth, entryHeight) && (tooltip = this.getTooltip(mouseX, mouseY)).isPresent() && tooltip.get().length > 0) {
            this.addTooltip(Tooltip.of(new Point(mouseX, mouseY), this.postProcessTooltip(tooltip.get())));
        }
    }

    private FormattedCharSequence[] postProcessTooltip(Component[] tooltip) {
        return (FormattedCharSequence[])Arrays.stream(tooltip).flatMap(component -> Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)component, this.getConfigScreen().f_96543_).stream()).toArray(FormattedCharSequence[]::new);
    }

    public Optional<Component[]> getTooltip() {
        if (this.tooltipSupplier != null) {
            return this.tooltipSupplier.get();
        }
        return Optional.empty();
    }

    public Optional<Component[]> getTooltip(int mouseX, int mouseY) {
        return this.getTooltip();
    }

    @Nullable
    public Supplier<Optional<Component[]>> getTooltipSupplier() {
        return this.tooltipSupplier;
    }

    public void setTooltipSupplier(@Nullable Supplier<Optional<Component[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
    }
}

