/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.math.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class MultiElementListEntry<T>
extends TooltipListEntry<T>
implements Expandable {
    private static final ResourceLocation CONFIG_TEX = new ResourceLocation("cloth-config2", "textures/gui/cloth_config.png");
    private final T object;
    private final List<AbstractConfigListEntry<?>> entries;
    private final CategoryLabelWidget widget;
    private final List<Object> children;
    private boolean expanded;

    @ApiStatus.Internal
    public MultiElementListEntry(Component categoryName, T object, List<AbstractConfigListEntry<?>> entries, boolean defaultExpanded) {
        super(categoryName, null);
        this.object = object;
        this.entries = entries;
        this.expanded = defaultExpanded;
        this.widget = new CategoryLabelWidget();
        this.children = Lists.newArrayList((Object[])new Object[]{this.widget});
        this.children.addAll(entries);
        this.setReferenceProviderEntries(entries);
    }

    @Override
    public boolean isRequiresRestart() {
        for (AbstractConfigListEntry<?> entry : this.entries) {
            if (!entry.isRequiresRestart()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEdited() {
        for (AbstractConfigListEntry<?> entry : this.entries) {
            if (!entry.isEdited()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<String> getSearchTags() {
        return Iterators.concat(super.getSearchTags(), (Iterator)Iterators.concat(this.entries.stream().map(AbstractConfigEntry::getSearchTags).iterator()));
    }

    @Override
    public void setRequiresRestart(boolean requiresRestart) {
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public Component getCategoryName() {
        return this.getFieldName();
    }

    @Override
    public T getValue() {
        return this.object;
    }

    @Override
    public Optional<T> getDefaultValue() {
        return Optional.empty();
    }

    @Override
    public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CONFIG_TEX);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280218_(CONFIG_TEX, x - 15, y + 5, 24, (this.widget.rectangle.contains(mouseX, mouseY) ? 18 : 0) + (this.expanded ? 9 : 0), 9, 9);
        graphics.m_280648_(Minecraft.m_91087_().f_91062_, this.getDisplayedFieldName().m_7532_(), x, y + 6, this.widget.rectangle.contains(mouseX, mouseY) ? -1638890 : -1);
        for (AbstractConfigListEntry<?> entry : this.entries) {
            entry.setParent(this.getParent());
            entry.setScreen(this.getConfigScreen());
        }
        if (this.expanded) {
            int yy = y + 24;
            for (AbstractConfigListEntry<?> entry : this.entries) {
                entry.render(graphics, -1, yy, x + 14, entryWidth - 14, entry.getItemHeight(), mouseX, mouseY, isHovered, delta);
                yy += entry.getItemHeight();
                yy += Math.max(0, entry.getMorePossibleHeight());
            }
        }
    }

    @Override
    public Rectangle getEntryArea(int x, int y, int entryWidth, int entryHeight) {
        this.widget.rectangle.x = x - 15;
        this.widget.rectangle.y = y;
        this.widget.rectangle.width = entryWidth + 15;
        this.widget.rectangle.height = 24;
        return new Rectangle(this.getParent().left, y, this.getParent().right - this.getParent().left, 20);
    }

    @Override
    public int getItemHeight() {
        if (this.expanded) {
            int i = 24;
            for (AbstractConfigListEntry<?> entry : this.entries) {
                i += entry.getItemHeight();
            }
            return i;
        }
        return 24;
    }

    @Override
    public void updateSelected(boolean isSelected) {
        for (AbstractConfigListEntry<?> entry : this.entries) {
            entry.updateSelected(this.expanded && isSelected && this.m_7222_() == entry);
        }
    }

    @Override
    public int getInitialReferenceOffset() {
        return 24;
    }

    @Override
    public void lateRender(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.expanded) {
            for (AbstractConfigListEntry<?> entry : this.entries) {
                entry.lateRender(graphics, mouseX, mouseY, delta);
            }
        }
    }

    @Override
    public int getMorePossibleHeight() {
        if (!this.expanded) {
            return -1;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 24;
        for (AbstractConfigListEntry<?> entry : this.entries) {
            i += entry.getItemHeight();
            if (entry.getMorePossibleHeight() < 0) continue;
            list.add(i + entry.getMorePossibleHeight());
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0) - this.getItemHeight();
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.expanded ? this.children : Collections.singletonList(this.widget);
    }

    @Override
    public List<? extends NarratableEntry> narratables() {
        return this.expanded ? this.children : Collections.singletonList(this.widget);
    }

    @Override
    public void save() {
        this.entries.forEach(AbstractConfigEntry::save);
    }

    @Override
    public Optional<Component> getError() {
        List errors = this.entries.stream().map(AbstractConfigEntry::getConfigError).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (errors.size() > 1) {
            return Optional.of(Component.m_237115_((String)"text.cloth-config.multi_error"));
        }
        return errors.stream().findFirst();
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public class CategoryLabelWidget
    implements GuiEventListener,
    NarratableEntry {
        private final Rectangle rectangle = new Rectangle();
        private boolean isHovered;

        public boolean m_6375_(double double_1, double double_2, int int_1) {
            if (this.rectangle.contains(double_1, double_2)) {
                MultiElementListEntry.this.expanded = !MultiElementListEntry.this.expanded;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.isHovered = true;
                return true;
            }
            this.isHovered = false;
            return false;
        }

        public void m_93692_(boolean bl) {
        }

        public boolean m_93696_() {
            return false;
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return this.isHovered ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, MultiElementListEntry.this.getFieldName());
        }
    }
}

